//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\
//                                                                   FFVI Menu                                                                    \\
//                                                                    System                                                                      \\
//                                                                                                                                                \\
//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\

var gameClock = new Clock();
gameClock.start();

var pick1 = undefined;

function drawText(x, y, text, colour, font)
{
  this.font = font || font2;
  var colour = colour || white;
  this.font.setColorMask(colour);
  this.font.drawText(x, y, text);
}




function clockObject()
{
  this.x = 216;
  this.y = 136;
  this.w = 64;
  this.h = 32;
  this.font = font2;
}

clockObject.prototype.draw = function()
{
  drawWindow(this.x, this.y, this.w, this.h);
  drawText(this.x + 17, this.y + 8, "Time", lightBlue);
  drawText(this.x + 57 - this.font.getStringWidth(gameClock.getTime()), this.y + 16, gameClock.getTime())
}




function stepsGpObject()
{
  this.x = 208;
  this.y = 168;
  this.w = 72;
  this.h = 56;
  this.font = font2;
}

stepsGpObject.prototype.draw = function()
{
  drawWindow(this.x, this.y, this.w, this.h);
  drawText(this.x + 8, this.y + 8, "Steps", lightBlue);
  drawText(this.x + 64 - this.font.getStringWidth(steps), this.y + 16, steps)
  drawText(this.x + 8, this.y + 32, "Gp", lightBlue);
  drawText(this.x + 64 - this.font.getStringWidth(gp), this.y + 40, gp)
}




function windowObject(x, y, w, h, text, colour, xOffset, yOffset, reverse)
{
  this.x = x;
  this.y = y;
  this.w = w;
  this.h = h;
  this.text = text || "";
  this.colour = colour;
  this.xOffset = xOffset || 0;
  this.yOffset = yOffset || 0;
  this.reverse = reverse || false;
}

windowObject.prototype.draw = function()
{
  drawWindow(this.x, this.y, this.w, this.h);
  drawText(this.x + this.xOffset, this.y + this.yOffset, this.text, this.colour);
}





function actorStatus(menu, update)
{
  this.x = 8;
  this.y = 8;
  this.menu = menu;
  this.update = update;
  this.font = LoadFont("Final Fantasy VI - Menu Font.rfn");
}

actorStatus.prototype.draw = function()
{
  partyA[this.menu.selection].face.blit(this.x + 192, this.y + 41);
  drawText(this.x + 176, this.y + 72, partyA[this.menu.selection].name);
  drawText(this.x + 120, this.y + 96, "Vigor", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].vigor), this.y + 96, partyA[this.menu.selection].vigor);
  drawText(this.x + 120, this.y + 108, "Speed", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].speed), this.y + 108, partyA[this.menu.selection].speed);
  drawText(this.x + 120, this.y + 120, "Stamina", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].stamina), this.y + 120, partyA[this.menu.selection].stamina);
  drawText(this.x + 120, this.y + 132, "Mag.Pwr", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].magPwr), this.y + 132, partyA[this.menu.selection].magPwr);
  drawText(this.x + 120, this.y + 144, "Bat.Pwr", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].batPwr), this.y + 144, partyA[this.menu.selection].batPwr);
  drawText(this.x + 120, this.y + 156, "Defense", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].defence), this.y + 156, partyA[this.menu.selection].defence);
  drawText(this.x + 120, this.y + 168, "Evade %", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].evade), this.y + 168, partyA[this.menu.selection].evade);
  drawText(this.x + 120, this.y + 180, "Mag.Def", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].magDef), this.y + 180, partyA[this.menu.selection].magDef);
  drawText(this.x + 120, this.y + 192, "MBlock%", lightBlue);
  drawText(this.x + 200 - this.font.getStringWidth(partyA[this.menu.selection].mBlock), this.y + 192, partyA[this.menu.selection].mBlock);
  for (var i = 0; i < 9; i++)
  {
    drawText(this.x + 200, this.y + 96 + (i * 12), ">", lightBlue);
  }
}






function actorDisplay(menu, x, y, w, h, window)
{
  this.menu = menu;
  this.x = x;
  this.y = y;
  this.w = w;
  this.h = h;
  this.window = window || true;
  this.font = font2;
}

actorDisplay.prototype.draw = function()
{
  drawWindow(this.x, this.y, this.w, this.h);
  
  partyA[this.menu.selection].face.blit(this.x + 16 + (12 * partyA[this.menu.selection].row), this.y + 9);
  drawText(this.x + 136, this.y + 8, "LV", lightBlue);
  drawText(this.x + 192 - this.font.getStringWidth(partyA[this.menu.selection].level), this.y + 8, partyA[this.menu.selection].level)
  drawText(this.x + 136, this.y + 20, "HP", lightBlue);
  drawText(this.x + 192 - this.font.getStringWidth(partyA[this.menu.selection].hp), this.y + 20, partyA[this.menu.selection].hp)
  drawText(this.x + 192, this.y + 20, "/");
  drawText(this.x + 232 - this.font.getStringWidth(partyA[this.menu.selection].maxHp), this.y + 20, partyA[this.menu.selection].maxHp)
  drawText(this.x + 136, this.y + 32, "MP", lightBlue);
  drawText(this.x + 192 - this.font.getStringWidth(partyA[this.menu.selection].mp), this.y + 32, partyA[this.menu.selection].mp)
  drawText(this.x + 192, this.y + 32, "/");
  drawText(this.x + 232 - this.font.getStringWidth(partyA[this.menu.selection].maxMp), this.y + 32, partyA[this.menu.selection].maxMp)
}




function itemDescription()
{
  this.menu = undefined
  this.x = 0;
  this.y = 0;
  this.w = 0;
  this.h = 0;
  this.xOffset = 8;
  this.yOffset = 8;
  this.text = ""
  this.pl = 0;
  this.lines = [];
  this.currentLine = 0;
  this.speed = 3;
  this.selection = undefined;
}

itemDescription.prototype.update = function()
{
  var numLines = this.lines.length - 1;
  if (this.lines[this.currentLine].position != this.lines[this.currentLine].line.length)
  {
    this.lines[this.currentLine].position += this.speed;
    if (this.lines[this.currentLine].position > this.lines[this.currentLine].line.length)
    {
      this.lines[this.currentLine].position = this.lines[this.currentLine].line.length;
    }
  }
  else
  {
    if (this.currentLine != numLines)
    {
      this.currentLine++;
    }
  }
}

itemDescription.prototype.updateDraw = function(x, y, w, h, current, item, menu)
{
  if (item[current] && this.text != item[current].info) this.selection = undefined;
  this.menu = menu;
  this.x = x;
  this.y = y;
  this.w = w;
  this.h = h;
  drawWindow(this.x, this.y, this.w, this.h);
  if (this.selection != current)
  {
    this.selection = current;
    if (item[current] && item[current].info != undefined) 
    {
      this.text = item[current].info;
      this.updateString(); 
    }
    else 
    {
      this.text = undefined; 
    }
  }
  else if (this.text && !this.menu.done) {
    this.update();
    this.draw(); }
}

itemDescription.prototype.updateString = function()
{
  this.currentLine = 0;
  this.lines = [];
  for (var i = 0; i < this.text.length; i++)
  {
    var currentLetter = 0;
    var currentLine = 0;
    var lastSpace = 0;
    var string = new String(this.text);
    while (currentLetter < string.length)
    {
      currentLetter++;
      if (string.charAt(currentLetter) == '\n') 
      {
        this.lines[currentLine] = new Object;
        this.lines[currentLine].line = string.substring(0,currentLetter);
        this.lines[currentLine].position = 0;
        string = string.slice (currentLetter + 1, string.length);
        currentLine++;
        currentLetter = 0;
        lastSpace = currentLetter;
      }
      if (string.charAt(currentLetter) == ' ') 
      {
        lastSpace = currentLetter; 
      }
      if (messageFont.getStringWidth(string.substring(0,currentLetter)) + this.xOffset > this.w - this.xOffset)
      {
        currentLetter = lastSpace;
        this.lines[currentLine] = new Object;
        this.lines[currentLine].line = string.substring(0,currentLetter);
        this.lines[currentLine].position = 0;
        string = string.slice (currentLetter + 1, string.length);
        currentLine++;
        currentLetter = 0;
      }
      if (currentLetter == string.length)
      {
        this.lines[currentLine] = new Object;
        this.lines[currentLine].line = string.substring(0,currentLetter);
        this.lines[currentLine].position = 0;
      }
    }
  }
}

itemDescription.prototype.draw = function()
{
  for (var i = 0; i < this.lines.length; i++)
  {
    drawText(this.x + this.xOffset, this.y + this.yOffset + (i * 12), this.lines[i].line.substring(0, this.lines[i].position), white, messageFont);
  }
}



function cursorObject(x, y)
{
  this.cursor = LoadImage("Final Fantasy VI - Cursor.png");
  this.x = x || 0;
  this.y = y || 0;
}




function getVigor(actor, type)
{
  var base = partyA[actor].vigor;
  
  for (var i = 0; i < 6; i++)
  {
    if (partyA[actor].equip[i] != undefined && type != i)
    {
      base += partyA[actor].equip[i].vigor;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getSpeed(actor, type)
{
  var base = partyA[actor].speed;
  
  for (var i = 0; i < 6; i++)
  {
    if (partyA[actor].equip[i] != undefined && type != i)
    {
      base += partyA[actor].equip[i].speed;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getStamina(actor, type)
{
  var base = partyA[actor].stamina;
  
  for (var i = 0; i < 6; i++)
  {
    if (partyA[actor].equip[i] != undefined && type != i)
    {
      base += partyA[actor].equip[i].stamina;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getMagPwr(actor, type)
{
  var base = partyA[actor].magPwr;
  
  for (var i = 0; i < 6; i++)
  {
    if (partyA[actor].equip[i] != undefined && type != i)
    {
      base += partyA[actor].equip[i].magPwr;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getBatPwr(actor, type)
{
  var base = partyA[actor].batPwr;
  
  for (var i = 0; i < 6; i++)
  {
    if (partyA[actor].equip[i] != undefined && type != i)
    {
      base += partyA[actor].equip[i].batPwr;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getDefence(actor, type)
{
  var base = partyA[actor].defence;
  
  for (var i = 0; i < 6; i++)
  {
    if (partyA[actor].equip[i] != undefined && type != i)
    {
      base += partyA[actor].equip[i].defence;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getEvade(actor, type)
{
  var base = partyA[actor].evade;
  
  for (var i = 0; i < 6; i++)
  {
    if (partyA[actor].equip[i] != undefined && type != i)
    {
      base += partyA[actor].equip[i].evade;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getMagDef(actor, type)
{
  var base = partyA[actor].magDef;
  
  for (var i = 0; i < 6; i++)
  {
    if (partyA[actor].equip[i] != undefined && type != i)
    {
      base += partyA[actor].equip[i].magDef;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}

function getMBlock(actor, type)
{
  var base = partyA[actor].mBlock;
  
  for (var i = 0; i < 6; i++)
  {
    if (partyA[actor].equip[i] != undefined && type != i)
    {
      base += partyA[actor].equip[i].mBlock;
    }
  }
  if (base > 255) { base = 255 }
  return base;
}





function menu(x, y, w, h, type)
{
  if (this instanceof menu == false) 
  {
    return new menu();
  }
  // PROPERTIES
  {
    this.name            = undefined;
    this.x               = x;
    this.y               = y;
    this.w               = w;
    this.h               = h;
    this.windowSkin      = true;
    this.font            = font2;
    this.cursor          = new cursorObject();
    this.done            = true;
    this.items           = [];
    this.selection       = 0;
    this.columnSelection = 0;
    this.topSelection    = 0;
    this.shownItems      = 0;
    this.numColumns      = 0;
    this.type            = type || "normal";
    this.party           = undefined;
  }
  // OFFSETS AND SPACING
  {
    this.ySpacing       = 15;
    this.xSpacing       = 0;
    this.yOffset        = 13;
    this.xOffset        = 10;
    this.cursorXOffset  = 16;
    this.cursorYOffset  = 0;
  }
  // OTHER MENUS
  {
    this.cursorClone = undefined;
    this.before = [];
    this.after = [];
  }
  this.textObject = function(name, callback)
  {
    this.name = name;
    this.callback = callback;
    this.x = 0; 
    this.y = 0;
  }
  
  this.escapeFunction = function() // The escape function
  {
    this.done = true;
    clearKeyQueue();
  }
  
  this.downFunction = function() {}
  this.upFunction = function() {}
  this.rightFunction = function() { this.selection++; this.columnSelection = 0; }
  this.leftFunction = function() {}
}

menu.prototype.updateItems = function()
{
  with (this)
  {
    for (var i = 0; i < items.length; i++)
    {
      //===Define the column======================================
      if (i == 0) // if there is only one item
      {
        {
          items[i].column = 0;
        }
      }
      else // if there is more than one column
      {
        if (items[i - 1].column + 1 > numColumns) // if the next column is more than the allowed
        {
          items[i].column = 0; // reset to 0 
        }
        else // otherwise...
        {
          items[i].column = items[i - 1].column + 1; // set column to the previous items value + 1
        }
      }
      //===Column defined=========================================
      if (i <= numColumns) // if items are less than number of columns
      {
        items[i].y = y //+ y_offset; // now we need to define the co-ords in here
      }
      else // otherwise...
      {
        if (numColumns == 0) // if columns is one the formula wont work so redevelop into
        {
          items[i].y = items[i - 1].y + ySpacing//- y_offset; // previous items y + y_spacing;
        }
        else // otherwise
        {
          items[i].y = items[i - (numColumns + 1)].y + ySpacing//- y_offset; // co-ords
        }
      }
      //========Y defined=========================================
      if (numColumns == 0)
      {
        items[i].x = (x + (xSpacing * items[i].column));
      }
      else
      {
        if (items[i].column == 0)
        {
          items[i].x = (x + xOffset);
        }
        else
        {
          items[i].x = (items[i - 1].x + font.getStringWidth(items[i - 1].name) + xSpacing);
        }
      }
      //========X defined=========================================
      items[i].width = font.getStringWidth(item.name); // gets the items width
      items[i].height = font.getHeight(); // gets the items height
    }
  }
}

menu.prototype.addItem = function(name, callback)
{
  return this.items[this.items.length] = new this.textObject(name, callback);
}

menu.prototype.handleInput = function()
{
  while (AreKeysLeft())
  {
    switch (GetKey()) 
    {
      case KEY_ENTER: 
      {
        var item = this.items[this.selection];
        item.callback();
        return;
      }
      case KEY_ESCAPE: 
      {
        this.escapeFunction();
        return;
      }
      case KEY_DOWN: 
      {
        if (this.selection + this.numColumns < this.items.length - 1) 
        {
          this.selection += 1 + this.numColumns;
          if (this.selection >= this.topSelection + this.shownItems) 
          {
            this.topSelection += 1 + this.numColumns;
          }
        }
        else
        {
          this.downFunction();
        }
        break;
      }
      case KEY_UP: 
      {
        if (this.selection > this.numColumns) 
        {
          this.selection -= 1 + this.numColumns;
          if (this.selection < this.topSelection) 
          {
            this.topSelection -= 1 + this.numColumns;
          }
        }
        else
        {
          this.upFunction();
        }
        break;
      }
      case KEY_RIGHT:
      {
        if (this.numColumns > 0 && this.selection < this.items.length - 1) 
        {
          this.columnSelection++;
          if (this.columnSelection > this.numColumns)
          {
            this.rightFunction();
          }
          else
          {
            this.selection++;
          }
          if (this.selection >= this.topSelection + this.shownItems) 
          {
            this.topSelection += 1 + this.numColumns;
          }
        }
        break;
      }
      case KEY_LEFT:
      {
        if (this.numColumns > 0 && this.selection > 0) 
        {
          this.selection--;
          if (this.selection < this.topSelection) 
          {
            this.topSelection -= 1 + this.numColumns;
          }
        }
        break;
      }
    }
  }
}

menu.prototype.drawActor = function(i, x, y)
{
  if (partyA[i] != undefined)
  {
    
    partyA[i].face.blit(x + (12 * partyA[i].row), y);
    drawText(x + 50, y, partyA[i].name);
    drawText(x + 66, y + 16, "LV", lightBlue);
    drawText(x + 66, y + 24, "HP", lightBlue);
    drawText(x + 66, y + 32, "MP", lightBlue);
    drawText(x + 122 - this.font.getStringWidth(partyA[i].level), y + 16, partyA[i].level);
    drawText(x + 122 - this.font.getStringWidth(partyA[i].hp), y + 24, partyA[i].hp);
    drawText(x + 121, y + 24, "/");
    drawText(x + 162 - this.font.getStringWidth(partyA[i].maxHp), y + 24, partyA[i].maxHp);
    drawText(x + 122 - this.font.getStringWidth(partyA[i].mp), y + 32, partyA[i].mp);
    drawText(x + 121, y + 32, "/");
    drawText(x + 162 - this.font.getStringWidth(partyA[i].maxMp), y + 32, partyA[i].maxMp);
  }
}

menu.prototype.draw = function()
{
  if (this.type == "normal") this.drawNormal();
  if (this.type == "party") this.drawParty();
  if (this.type == "item") this.drawItem();
  if (this.type == "rare") this.drawRare();
  if (this.type == "equip") this.drawEquip();
  if (this.type == "relic") this.drawRelic();
  if (this.type == "equipItem") this.drawEquipItem();
  if (this.type == "itemInfo") this.drawItemInfo(menus[4].selection);
  if (this.type == "status") this.drawStatus();
  if (this.type == "skillsTop") this.drawSkillsTop();
  if (this.type == "magic") this.drawMagic();
  if (this.type == "espers") this.drawEspers();
  if (this.type == "swordTech") this.drawSwordTech();
  if (this.type == "blitz") this.drawBlitz();
  if (this.type == "lore") this.drawLore();
  if (this.type == "rage") this.drawRage();
  if (this.type == "dance") this.drawDance();
  if (this.type == "save") this.drawSave();
  if (this.type == "partyChanger") this.drawPartyChanger();
  if (!this.done) {
    this.cursor.cursor.blit(this.cursor.x, this.cursor.y); }
}

menu.prototype.drawNormal = function()
{
  for (var i = 0; i < this.items.length; i++)
  {
    drawText(0, 0 + (i * 8), this.items[i].x + " " + this.items[i].y);
  }
  drawWindow(this.x, this.y, this.w, this.h);
  with (this) // Use this menus stats
  {
    for (var i = 0; i < items.length; i++) // loop to check items
    {
      if (items[i].y >= y && items[i].y + items[i].height < y + h - (yOffset * 2) + 18 && // this checks if the item is within the menu and is visible
      items[i].x >= x && items[i].x + items[i].width < x + w + 16) // this checks if the item is within the menu and is visible
      {
        drawText(xOffset + items[i].x, yOffset + items[i].y, items[i].name, items[i].color);
      }
    }
  }
  //this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  //if (this.numColumns > 0) {
  //  this.shownItems *= (this.numColumns + 1); }
    
  //var column = 0;
  //var line = 0;
  //var x = this.x + this.xOffset;
  
  
  
  //for (var i = 0; i < this.shownItems; i++) 
  //{
  //  if (i < this.items.length) 
  //  {
  //    //===================COLUMNS=======================
  //    if (column > 0) {
  //      x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
  //    else {
  //      x = this.x + this.xOffset; }
  //    var y = this.y + this.yOffset + (line * this.ySpacing);
  //
  //    drawText(x, y, this.items[i + this.topSelection].name);
  //
  //    if (this.selection == i + this.topSelection) {
  //      this.cursor.x = x - this.cursorXOffset;
  //      this.cursor.y = y; }
  //    column++;
  //    if (column > this.numColumns) {
  //      column = 0;
  //      line++; }
  //  }
  //}
}

menu.prototype.drawParty = function()
{
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    var y = this.y + this.yOffset + (i * this.ySpacing);
    if (i < this.items.length) 
    {
      this.drawActor(i, x, y);
    }
    if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
  }
}

menu.prototype.drawItem = function()
{
  descriptionWindow.updateDraw(40, 48, 240, 40, this.selection, partyItems, this);
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      var y = this.y + this.yOffset + (i * this.ySpacing);
      if (partyItems[i + this.topSelection])
      {
        var colour = white;
        if (partyItems[i + this.topSelection] instanceof itemObject == false) colour = grey;
        if (partyItems[i + this.topSelection].icon) partyItems[i + this.topSelection].icon.blitMask(x - 8, y, colour);
        
        drawText(x, y, partyItems[i + this.topSelection].name, colour);
        drawText(x + 94, y, ":", colour)
        drawText(x + 118 - this.font.getStringWidth(partyItems[i + this.topSelection].quantity), y, partyItems[i + this.topSelection].quantity, colour);
        if (partyItems[i + this.topSelection].type) drawText(x + 136, y, partyItems[i + this.topSelection].type, colour);
      }
      if (this.cursorClone == [i + this.topSelection])
      {
        this.cursor.cursor.blit(x - this.cursorXOffset + 4, y - 4);
      }
    }
    if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
  }
}

menu.prototype.drawRare = function()
{
  descriptionWindow.updateDraw(40, 48, 240, 40, this.selection, partyRareItems, this);
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);
      
      if (partyRareItems[i + this.topSelection])
      {
        drawText(x, y, partyRareItems[i + this.topSelection].name);
      }
      
      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
}

menu.prototype.drawEquip = function()
{
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  partyA[menus[1].selection].face.blit(this.x + 192, this.y + 25);
  drawText(this.x + 176, this.y + 56, partyA[menus[1].selection].name);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    var y = this.y + this.yOffset + (i * this.ySpacing);
    if (i < this.items.length) 
    {
      drawText(x, y, this.items[i + this.topSelection].name, lightBlue);
      if (partyA[menus[1].selection].equip[i + this.topSelection])
      {
        partyA[menus[1].selection].equip[i + this.topSelection].icon.blit(x + 64 - 8, y);
        drawText(x + 64, y, partyA[menus[1].selection].equip[i + this.topSelection].name);
      }
      else
      {
        drawText(x + 64, y, "Empty");
      }
    }
    if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
  }
  
  this.drawActorStatusEquip(menus[17]);
}

menu.prototype.drawRelic = function()
{
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  partyA[menus[1].selection].face.blit(this.x + 192, this.y + 25);
  drawText(this.x + 176, this.y + 56, partyA[menus[1].selection].name);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    var y = this.y + this.yOffset + (i * this.ySpacing);
    if (i < this.items.length) 
    {
      drawText(x, y, this.items[i + this.topSelection].name, lightBlue);
      if (partyA[menus[1].selection].equip[i + this.topSelection + 4])
      {
        partyA[menus[1].selection].equip[i + this.topSelection + 4].icon.blit(x + 64 - 8, y);
        drawText(x + 64, y, partyA[menus[1].selection].equip[i + this.topSelection + 4].name);
      }
      else
      {
        drawText(x + 64, y, "Empty");
      }
    }
    if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
  }
  
  this.drawActorStatusEquip(menus[21], 4);
}

menu.prototype.drawActorStatusEquip = function(full, ext)
{
  var ext = ext || 0;
  var y = this.y + 72;
  drawText(this.x + 120, y + 8, "Vigor", lightBlue);
  var temp = getVigor(menus[1].selection);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 8, temp);
  drawText(this.x + 120, y + 20, "Speed", lightBlue);
  temp = getSpeed(menus[1].selection);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 20, temp);
  drawText(this.x + 120, y + 32, "Stamina", lightBlue);
  temp = getStamina(menus[1].selection);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 32, temp);
  drawText(this.x + 120, y + 44, "Mag.Pwr", lightBlue);
  temp = getMagPwr(menus[1].selection);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 44, temp);
  drawText(this.x + 120, y + 56, "Bat.Pwr", lightBlue);
  temp = getBatPwr(menus[1].selection);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 56, temp);
  drawText(this.x + 120, y + 68, "Defense", lightBlue);
  temp = getDefence(menus[1].selection);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 68, temp);
  drawText(this.x + 120, y + 80, "Evade %", lightBlue);
  temp = getEvade(menus[1].selection);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 80, temp);
  drawText(this.x + 120, y + 92, "Mag.Def", lightBlue);
  temp = getMagDef(menus[1].selection);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 92, temp);
  drawText(this.x + 120, y + 104, "MBlock%", lightBlue);
  temp = getMBlock(menus[1].selection);
  drawText(this.x + 200 - this.font.getStringWidth(temp), y + 104, temp);
  for (var i = 0; i < 9; i++)
  {
    drawText(this.x + 200, y + 8 + (i * 12), ">", lightBlue);
  }
  if (!full.done)
  {
    var temp = getVigor(menus[1].selection, this.selection + ext) + partyItems[full.items[full.selection].name].vigor;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getVigor(menus[1].selection)) colour = yellow;
    if (temp < getVigor(menus[1].selection)) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 8, temp, colour);
    var temp = getSpeed(menus[1].selection, this.selection + ext) + partyItems[full.items[full.selection].name].speed;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getSpeed(menus[1].selection)) colour = yellow;
    if (temp < getSpeed(menus[1].selection)) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 20, temp, colour);
    var temp = getStamina(menus[1].selection, this.selection + ext) + partyItems[full.items[full.selection].name].stamina;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getStamina(menus[1].selection)) colour = yellow;
    if (temp < getStamina(menus[1].selection)) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 32, temp, colour);
    var temp = getMagPwr(menus[1].selection, this.selection + ext) + partyItems[full.items[full.selection].name].magPwr;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getMagPwr(menus[1].selection)) colour = yellow;
    if (temp < getMagPwr(menus[1].selection)) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 44, temp, colour);
    var temp = getBatPwr(menus[1].selection, this.selection + ext) + partyItems[full.items[full.selection].name].batPwr;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getBatPwr(menus[1].selection)) colour = yellow;
    if (temp < getBatPwr(menus[1].selection)) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 56, temp, colour);
    var temp = getDefence(menus[1].selection, this.selection + ext) + partyItems[full.items[full.selection].name].defence;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getDefence(menus[1].selection)) colour = yellow;
    if (temp < getDefence(menus[1].selection)) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 68, temp, colour);
    var temp = getEvade(menus[1].selection, this.selection + ext) + partyItems[full.items[full.selection].name].evade;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getEvade(menus[1].selection)) colour = yellow;
    if (temp < getEvade(menus[1].selection)) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 80, temp, colour);
    var temp = getMagDef(menus[1].selection, this.selection + ext) + partyItems[full.items[full.selection].name].magDef;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getMagDef(menus[1].selection)) colour = yellow;
    if (temp < getMagDef(menus[1].selection)) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 92, temp, colour);
    var temp = getMBlock(menus[1].selection, this.selection + ext) + partyItems[full.items[full.selection].name].mBlock;
    if (temp > 255) temp = 255;
    var colour = white;
    if (temp > getMBlock(menus[1].selection)) colour = yellow;
    if (temp < getMBlock(menus[1].selection)) colour = grey;
    drawText(this.x + 232 - this.font.getStringWidth(temp), y + 104, temp, colour);
  }
}

menu.prototype.drawEquipItem = function()
{
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    var y = this.y + this.yOffset + (i * this.ySpacing);
    if (i < this.items.length) 
    {
      var colour = white;
      partyItems[this.items[i + this.topSelection].name].icon.blit(x - 8, y);
      drawText(x, y, partyItems[this.items[i + this.topSelection].name].name);
    }
    if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
  }
}

menu.prototype.drawItemStats = function(x, y)
{
  drawWindow(x, y, 120, 208);
  drawText(x + 8, y + 92, "Vigor", lightBlue);
  drawText(x + 72, y + 89, ".", lightBlue); drawText(x + 76, y + 89, ".", lightBlue); 
  drawText(x + 8, y + 104, "Speed", lightBlue);
  drawText(x + 72, y + 101, ".", lightBlue); drawText(x + 76, y + 101, ".", lightBlue); 
  drawText(x + 8, y + 116, "Stamina", lightBlue);
  drawText(x + 72, y + 113, ".", lightBlue); drawText(x + 76, y + 113, ".", lightBlue); 
  drawText(x + 8, y + 128, "Mag.Pwr", lightBlue);
  drawText(x + 72, y + 125, ".", lightBlue); drawText(x + 76, y + 125, ".", lightBlue); 
  drawText(x + 8, y + 140, "Bat.Pwr", lightBlue);
  drawText(x + 72, y + 137, ".", lightBlue); drawText(x + 76, y + 137, ".", lightBlue); 
  drawText(x + 8, y + 152, "Defense", lightBlue);
  drawText(x + 72, y + 149, ".", lightBlue); drawText(x + 76, y + 149, ".", lightBlue); 
  drawText(x + 8, y + 166, "Evade %", lightBlue);
  drawText(x + 72, y + 163, ".", lightBlue); drawText(x + 76, y + 163, ".", lightBlue); 
  drawText(x + 8, y + 178, "Mag.Def", lightBlue);
  drawText(x + 72, y + 175, ".", lightBlue); drawText(x + 76, y + 175, ".", lightBlue); 
  drawText(x + 8, y + 190, "MBlock%", lightBlue);
  drawText(x + 72, y + 187, ".", lightBlue); drawText(x + 76, y + 187, ".", lightBlue); 
}

menu.prototype.drawItemInfo = function(selection)
{
  descriptionWindow.updateDraw(40, 48, 240, 40, selection, partyItems, this);
  drawWindow(this.x, this.y, this.w, this.h);
  
  //drawText(this.x + 8, this.y + 8, "Attack", lightBlue);
  
  drawText(this.x + 16, this.y + 56, partyItems[selection].name + " can be used by:", lightBlue);
  
  var line = 0;
  var column = 0;
  for (var i = 0; i < partyItems[selection].equip.length; i++)
  {
    drawText(this.x + 16 + (column * 80), this.y + 68 + (line * 12), actor[partyItems[selection].equip[i]].name);
    column++;
    if (column > 2)
    {
      column = 0;
      line++
    }
  }
  this.drawItemStats(this.x - 120, 16);
}

menu.prototype.drawSkillsTop = function()
{
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);
      
      var colour = grey;
      if (actorCanUseSkill(this.items[i + this.topSelection].name, partyA[menus[1].selection]))
      {
        colour = white;
      }

      drawText(x, y, this.items[i + this.topSelection].name, colour);

      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
}

menu.prototype.drawMagic = function()
{
  if (partyA[menus[1].selection].magic[this.selection])
  {
    descriptionWindow.updateDraw(40, 16, 240, 40, this.selection, skillMagic, this);
  }
  else
  {
    drawWindow(40, 16, 240, 40);
  }
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);
      
      if (partyA[menus[1].selection].magic[i + this.topSelection])
      {
        partyA[menus[1].selection].magic[i + this.topSelection].icon.blit(x - 8, y);
        drawText(x, y, partyA[menus[1].selection].magic[i + this.topSelection].name);
      }
      
      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
  drawWindow(208, 40, 72, 24);
  drawText(216, 46, "MP", lightBlue);
  drawText(232, 44, ".", lightBlue);
  drawText(235, 44, ".", lightBlue);
  drawText(238, 44, ".", lightBlue);
  if (partyA[menus[1].selection].magic[this.selection])
  {
    drawText(264 - this.font.getStringWidth(partyA[menus[1].selection].magic[this.selection].mpCost), 46, partyA[menus[1].selection].magic[this.selection].mpCost);
  }
  else
  {
    drawText(256, 46, "0");
  }
}

menu.prototype.drawEspers = function()
{
  if (partyEspers[this.selection])
  {
    descriptionWindow.updateDraw(40, 16, 240, 40, this.selection, espers, this);
  }
  else
  {
    drawWindow(40, 16, 240, 40);
  }
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);
      if (partyEspers[i + this.topSelection])
      {
        drawText(x, y, espers[i + this.topSelection].name);
      }
      
      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
  drawWindow(208, 40, 72, 24);
  drawText(216, 46, "Espers", lightBlue);
}

menu.prototype.drawSwordTech = function()
{
  if (partySwordTech[this.selection])
  {
    descriptionWindow.updateDraw(40, 16, 240, 40, this.selection, skillSwordTech, this);
  }
  else
  {
    drawWindow(40, 16, 240, 40);
  }
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);
      if (partySwordTech[i + this.topSelection])
      {
        drawText(x, y, skillSwordTech[i + this.topSelection].name);
      }
      
      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
  drawWindow(208, 40, 72, 24);
  drawText(216, 46, "SwdTech", lightBlue);
}

menu.prototype.drawBlitz = function()
{
  if (partyBlitz[this.selection])
  {
    descriptionWindow.updateDraw(40, 16, 240, 40, this.selection, skillBlitz, this);
  }
  else
  {
    drawWindow(40, 16, 240, 40);
  }
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);
      if (partyBlitz[i + this.topSelection])
      {
        skillBlitz[i + this.topSelection].image.blit(x, y);
      }
      
      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
  drawWindow(208, 40, 72, 24);
  drawText(216, 46, "Blitz", lightBlue);
}

menu.prototype.drawLore = function()
{
  if (partyLore[this.selection])
  {
    descriptionWindow.updateDraw(40, 16, 240, 40, this.selection, skillLore, this);
  }
  else
  {
    drawWindow(40, 16, 240, 40);
  }
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);
      if (partyLore[i + this.topSelection])
      {
        drawText(x, y, skillLore[i + this.topSelection].name);
        drawText(x + 80, y - 2, ".");
        drawText(x + 83, y - 2, ".");
        drawText(x + 86, y - 2, ".");
        drawText(x + 112 - this.font.getStringWidth(skillLore[i + this.topSelection].mpCost), y, skillLore[i + this.topSelection].mpCost);
      }
      
      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
  drawWindow(208, 40, 72, 24);
  drawText(216, 46, "Lore", lightBlue);
}

menu.prototype.drawRage = function()
{
  drawWindow(40, 16, 240, 40);
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);
      if (partyRage[i + this.topSelection])
      {
        drawText(x, y, skillRage[i + this.topSelection].name);
      }
      
      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
  drawWindow(208, 40, 72, 24);
  drawText(216, 46, "Rage", lightBlue);
}

menu.prototype.drawDance = function()
{
  if (partyDance[this.selection])
  {
    descriptionWindow.updateDraw(40, 16, 240, 40, this.selection, skillDance, this);
  }
  else
  {
    drawWindow(40, 16, 240, 40);
  }
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);
      if (partyDance[i + this.topSelection])
      {
        drawText(x, y, skillDance[i + this.topSelection].name);
      }
      
      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
  drawWindow(208, 40, 72, 24);
  drawText(216, 46, "Dance", lightBlue);
}

menu.prototype.drawStatus = function()
{
  var actor = menus[1].selection
  drawWindow(this.x, this.y, this.w, this.h);
  drawText(this.x + 16 + (12 * partyA[actor].row), this.y + 30, partyA[actor].name)
  partyA[actor].face.blit(this.x + 6, this.y + 49);
  drawText(this.x + 72, this.y + 46, "LV", lightBlue);
  drawText(this.x + 128 - this.font.getStringWidth(partyA[actor].level), this.y + 46, partyA[actor].level);
  drawText(this.x + 72, this.y + 54, "HP", lightBlue);
  drawText(this.x + 128 - this.font.getStringWidth(partyA[actor].hp), this.y + 54, partyA[actor].hp);
  drawText(this.x + 128, this.y + 54, "/");
  drawText(this.x + 168 - this.font.getStringWidth(partyA[actor].maxHp), this.y + 54, partyA[actor].maxHp);
  drawText(this.x + 72, this.y + 62, "MP", lightBlue);
  drawText(this.x + 128 - this.font.getStringWidth(partyA[actor].mp), this.y + 62, partyA[actor].mp);
  drawText(this.x + 128, this.y + 62, "/");
  drawText(this.x + 168 - this.font.getStringWidth(partyA[actor].maxMp), this.y + 62, partyA[actor].maxMp);
  
  drawText(this.x + 8, this.y + 96, "Your Exp:", lightBlue);
  drawText(this.x + 110 - this.font.getStringWidth(partyA[actor].exp), this.y + 108, partyA[actor].exp);
  
  drawText(this.x + 8, this.y + 120, "For level up:", lightBlue);
  drawText(this.x + 110 - this.font.getStringWidth((partyA[actor].nextExp - partyA[actor].exp)), this.y + 132, (partyA[actor].nextExp - partyA[actor].exp));
  
  drawText(this.x + 16, this.y + 156, "Vigor", lightBlue);
  drawText(this.x + 72, this.y + 153, "..", lightBlue);
  drawText(this.x + 112 - this.font.getStringWidth(getVigor(actor)), this.y + 156, getVigor(actor));
  
  drawText(this.x + 16, this.y + 168, "Speed", lightBlue);
  drawText(this.x + 72, this.y + 165, "..", lightBlue);
  drawText(this.x + 112 - this.font.getStringWidth(getSpeed(actor)), this.y + 168, getSpeed(actor));
  
  drawText(this.x + 16, this.y + 180, "Stamina", lightBlue);
  drawText(this.x + 72, this.y + 177, "..", lightBlue);
  drawText(this.x + 112 - this.font.getStringWidth(getStamina(actor)), this.y + 180, getStamina(actor));
  
  drawText(this.x + 16, this.y + 192, "Mag.Pwr", lightBlue);
  drawText(this.x + 72, this.y + 189, "..", lightBlue);
  drawText(this.x + 112 - this.font.getStringWidth(getMagPwr(actor)), this.y + 192, getMagPwr(actor));
  
  drawText(this.x + 120, this.y + 144, "Bat.Pwr", lightBlue);
  drawText(this.x + 192, this.y + 141, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getBatPwr(actor)), this.y + 144, getBatPwr(actor));
  
  drawText(this.x + 120, this.y + 156, "Defense", lightBlue);
  drawText(this.x + 192, this.y + 153, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getDefence(actor)), this.y + 156, getDefence(actor));
  
  drawText(this.x + 120, this.y + 168, "Evade %", lightBlue);
  drawText(this.x + 192, this.y + 165, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getEvade(actor)), this.y + 168, getEvade(actor));
  drawText(this.x + 224, this.y + 168, "%");
  
  drawText(this.x + 120, this.y + 180, "Mag.Def", lightBlue);
  drawText(this.x + 192, this.y + 177, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getMagDef(actor)), this.y + 180, getMagDef(actor));
  
  drawText(this.x + 120, this.y + 192, "MBlock%", lightBlue);
  drawText(this.x + 192, this.y + 189, "..", lightBlue);
  drawText(this.x + 224 - this.font.getStringWidth(getMBlock(actor)), this.y + 192, getMBlock(actor));
  drawText(this.x + 224, this.y + 192, "%");
  
  drawWindow(this.x + 128, this.y + 72, 88, 64);
}

menu.prototype.drawSave = function()
{
  drawWindow(this.x, this.y, 240, 32);
  drawText(this.x + 112, this.y + 16, "Save");
  for (var i = 0; i < 3; i++)
  {
    this.drawSaveFile("File " + i, i *  56);
  }
  this.cursor.x = this.x;
  this.cursor.y = this.y + 46 + (56 * this.selection);
}

menu.prototype.drawSaveFile = function(filename, space)
{
  var file = OpenFile(filename);
  
  drawWindow(this.x, this.y + 32 + space, 240, 56);
  
  if (file.read("Empty", true) == false)
  {
    var name = file.read("name", undefined);
    drawText(this.x + 16, this.y + 32 + space + 14, name);
    drawText(this.x + 16, this.y + 32 + space + 32, "Time", lightBlue);
    
    var time = file.read("time", undefined);
    drawText(this.x + 48 - this.font.getStringWidth(time), this.y + 32 + space + 40, time);
    drawText(this.x + 192, this.y + 32 + space + 16, "LV", lightBlue);
    
    var lv = file.read("lv", undefined);
    drawText(this.x + 232 - this.font.getStringWidth(lv), this.y + 32 + space + 16, lv);
    
    var hp = file.read("hp", undefined);
    drawText(this.x + 192 - this.font.getStringWidth(hp), this.y + 32 + space + 32, hp);
    drawText(this.x + 192, this.y + 32 + space + 32, "/");
    
    var maxHp = file.read("maxHp", undefined);
    drawText(this.x + 232 - this.font.getStringWidth(maxHp), this.y + 32 + space + 32, maxHp);
    
    for (var i = 0; i < 4; i++)
    {
      var id = file.read("pos" + i, undefined);
      if (id != "undefined")
      {
        this.drawSprite(this.x + 68 + (i * 24), this.y + 32 + space + 18, id);
      }
    }
  }
  else
  {
    drawText(this.x + 16, this.y + 32 + space + 14, "Empty");
  }
}

menu.prototype.drawPartyChanger = function()
{
  this.shownItems = Math.floor((this.h - this.yOffset) / this.ySpacing);
  
  if (this.numColumns > 0) {
    this.shownItems *= (this.numColumns + 1); }
    
  var column = 0;
  var line = 0;
  var x = this.x + this.xOffset;
  
  drawWindow(this.x, this.y, this.w, this.h);
  
  for (var i = 0; i < this.shownItems; i++) 
  {
    if (i < this.items.length) 
    {
      //===================COLUMNS=======================
      if (column > 0) {
        x += this.font.getStringWidth(this.items[i + this.topSelection - 1].name) + this.xSpacing; }
      else {
        x = this.x + this.xOffset; }
      var y = this.y + this.yOffset + (line * this.ySpacing);

      if (this.party[i])
      {
        this.drawSprite(x, y, this.party[i].id);
      }

      if (this.selection == i + this.topSelection) {
        this.cursor.x = x - this.cursorXOffset;
        this.cursor.y = y; }
      column++;
      if (column > this.numColumns) {
        column = 0;
        line++; }
    }
  }
}

menu.prototype.drawSprite = function(x, y, id)
{
  var sprite = actor[id].sprite;
  var index = 0;
  var dir = "west";
  var frame = 0;
  for(var i = 0; i < sprite.directions.length; i++) 
  {
    if(sprite.directions[i].name == dir) 
    {
      index = i;			
      break;		
    }
  }
  sprite.images[sprite.directions[index].frames[frame].index].createSurface().createImage().blit(x,y);
}

menu.prototype.render = function()
{
  for (var i = 0; i < this.before.length; i++) {
    menus[this.before[i]].draw(); }
  this.draw();
  for (var i = 0; i < this.after.length; i++) {
    menus[this.after[i]].draw(); }
  FlipScreen();
}

menu.prototype.execute = function()
{
  while(!this.done)
  {
    this.render();
    this.handleInput();
  }
}

var menus = [];

// MAIN MENU
menus[0] = new menu(216, 16, 64, 120, "normal");
menus[0].addItem("Item", function() { menus[0].done = true; menus[4].done = false; menus[4].execute(); });
menus[0].addItem("Skills", function() { menus[0].done = true; menus[1].done = false; menus[1].execute(); });
menus[0].addItem("Equip", function() { menus[0].done = true; menus[1].done = false; menus[1].execute(); });
menus[0].addItem("Relic", function() { menus[0].done = true; menus[1].done = false; menus[1].execute(); });
menus[0].addItem("Status", function() { menus[0].done = true; menus[1].done = false; menus[1].execute(); });
menus[0].addItem("Config", function() { menus[0].done = true; menus[24].done = false; menus[24].execute(); });
menus[0].addItem("Save", function() { menus[0].done = true; menus[26].done = false; menus[26].execute(); });
menus[0].before = [1];
menus[0].after = [2, 3];
menus[0].escapeFunction = function() {
for (var i = 0; i < menus.length; i++)
{
  menus[i].selection = 0;
}
  menus[0].done = true;
}
menus[0].updateItems();

// PARTY MENU
menus[1] = new menu(40,16, 240, 208, "party");
menus[1].addItem(undefined, partyPick);
menus[1].addItem(undefined, partyPick);
menus[1].addItem(undefined, partyPick);
menus[1].addItem(undefined, partyPick);
menus[1].ySpacing = 48;
menus[1].yOffset = 14;
menus[1].xOffset = 6;
menus[1].after = [0, 2, 3];
menus[1].escapeFunction = function() { menus[1].done = true; menus[0].done = false; menus[0].execute; }

// TIME WINDOW
menus[2] = new clockObject(); // Time window

// STEPS AND GP WINDOW
menus[3] = new stepsGpObject(); // Steps and GP window

// ITEM MENU
menus[4] = new menu(40, 88, 240, 136, "item");
for (var i = 0; i < gameItems.length; i++)
{
  menus[4].addItem(undefined, useItem);
}
menus[4].ySpacing = 12;
menus[4].xOffset = 25;
menus[4].yOffset = 12;
menus[4].after = [5, 6];
menus[4].cursorXOffset = 24;
menus[4].escapeFunction = function() { menus[4].done = true; menus[5].done = false; menus[5].before = [4, 6]; menus[5].execute(); }

// ITEM TOP MENU
menus[5] = new menu(88, 16, 192, 32);
menus[5].addItem("USE", function() { menus[5].done = true; menus[4].done = false; menus[4].execute(); });
menus[5].addItem("ARRANGE", arrange);
menus[5].addItem("RARE", function() { menus[5].done = true, menus[8].done = false; menus[9].show = true;  menus[8].execute(); });
menus[5].numColumns = 2;
menus[5].xSpacing = 16;
menus[5].xOffset = 24;
menus[5].before = [6];
menus[5].escapeFunction = function() { menus[5].done = true; menus[0].done = false; menus[0].execute(); }

// ITEM TOP LEFT WINDOW
menus[6] = new windowObject(40, 16, 48, 32, "Item", lightBlue, 10, 16);

// ITEM DESCRIPTION WINDOW
var descriptionWindow = new itemDescription();

menus[7] = new menu(40, 88, 240, 136, "itemInfo");
menus[7].before = [5, 6];
menus[7].escapeFunction = function() { pick1 = undefined; menus[4].cursorClone = undefined; menus[7].done = true, menus[4].done = false, menus[4].execute(); }

// RARE ITEM MENU
menus[8] = new menu(40, 88, 240, 136, "rare");
for (var i = 0; i < 20; i++)
{
  menus[8].addItem(undefined, function() {});
}
menus[8].after = [5, 6, 9];
menus[8].numColumns = 1;
menus[8].xSpacing = 112;
menus[8].xOffset = 16;
menus[8].ySpacing = 12;
menus[8].yOffset = 12;
menus[8].escapeFunction = function() { menus[8].done = true; menus[5].done = false, menus[5].before = [8, 6]; menus[5].execute(); }

// RARE ITEM DECRIPTION
menus[9] = new itemDescription(partyRareItems, menus[8], 8, 40, 240, 40, true);

// SKILLS MENU
menus[10] = new menu(40, 112, 240, 112);
menus[10].before = [12];

// SKILLS DESCRIPTION
menus[11] = new windowObject(40, 16, 240, 40);

// SKILLS ACTOR
menus[12] = new actorDisplay(menus[1], 40, 56, 240, 56, true);

// SKILLS MENU TOP
menus[13] = new menu(40, 16, 72, 48, "skillsTop");
menus[13].addItem("Espers", function() { skillsEspers(13) });
menus[13].addItem("Magic", function() { skillsMagic(13) });
menus[13].before = [10, 11, 12];
menus[13].after = [14];
menus[13].downFunction = function() { menus[13].done = true; menus[14].done = false; menus[14].execute(); }
menus[13].escapeFunction = function() { menus[13].done = true; menus[0].done = false; menus[0].execute(); }

// SKILLS MENU BOTTOM
menus[14] = new menu(40, 64, 72, 96, "skillsTop")
menus[14].addItem("SwdTech", function() { skillsSwordTech(13); });
menus[14].addItem("Blitz", function() { skillsBlitz(13); });
menus[14].addItem("Lore", function() { skillsLore(13); });
menus[14].addItem("Rage", function() { skillsRage(13); });
menus[14].addItem("Dance", function() { skillsDance(13); });
menus[14].before = [10, 11, 12, 13];
menus[14].escapeFunction = function() { menus[14].done = true; menus[0].done = false; menus[0].execute(); }
menus[14].upFunction = function() { menus[14].done = true; menus[13].done = false; menus[13].execute(); }

// EQUIP TOP MENU
menus[15] = new menu(40, 16, 240, 32);
menus[15].addItem("EQUIP", function() { menus[15].done = true; menus[16].done = false; menus[18].text = "EQUIP"; menus[16].execute(); });
menus[15].addItem("OPTIMUM", function() {});
menus[15].addItem("RMOVE", function() { menus[15].done = true; menus[16].done = false; menus[18].text = "REMOVE"; menus[16].execute(); });
menus[15].addItem("EMPTY", function() {});
menus[15].numColumns = 3;
menus[15].xOffset = 8;
menus[15].yOffset = 12;
menus[15].xSpacing = 16;
menus[15].before = [17, 16];
menus[15].escapeFunction = function() { menus[15].done = true; menus[0].done = false; menus[0].execute(); }

// EQUIP MENU
menus[16] = new menu(40, 32, 240, 72, "equip"); // this will be wrong
menus[16].addItem("R-hand", function() { equipItems(0) } );
menus[16].addItem("L-hand", function() { equipItems(1) } );
menus[16].addItem("Head", function() { equipItems(2) } );
menus[16].addItem("Body", function() { equipItems(3) } );
menus[16].yOffset = 20;
menus[16].ySpacing = 12;
menus[16].before = [17];
menus[16].after = [18];
menus[16].escapeFunction = function() { menus[16].done = true; menus[15].done = false; menus[15].execute(); }

// EQUIP ITEM MENU
menus[17] = new menu(40, 104, 240, 120, "equipItem");
menus[17].xOffset = 16;
menus[17].yOffset = 8;
menus[17].ySpacing = 12;
menus[17].cursorXOffset = 24;
menus[17].after = [16, 18];
menus[17].escapeFunction = function() { menus[17].done = true; menus[17].items = []; menus[17].selection = 0; menus[17].topSelection = 0; menus[16].done = false; menus[16].execute(); }

// EQUIP TOP LEFT WINDOW
menus[18] = new windowObject(216, 16, 64, 32, undefined, lightBlue, 8, 12);

// RELIC TOP MENU
menus[19] = new menu(40, 16, 240, 32);
menus[19].addItem("EQUIP", function() { menus[19].done = true; menus[20].done = false; menus[18].text = "EQUIP"; menus[20].execute(); });
menus[19].addItem("REMOVE", function() {});
menus[19].numColumns = 1;
menus[19].xOffset = 8;
menus[19].yOffset = 12;
menus[19].xSpacing = 16;
menus[19].before = [21, 20];
menus[19].escapeFunction = function() { menus[19].done = true; menus[0].done = false; menus[0].execute(); }

// RELIC MENU
menus[20] = new menu(40, 32, 240, 72, "relic"); // this will be wrong
menus[20].addItem("Relic", function() { equipItems(4) } );
menus[20].addItem("Relic", function() { equipItems(4) } );
menus[20].yOffset = 44;
menus[20].ySpacing = 12;
menus[20].before = [21];
menus[20].after = [18];
menus[20].escapeFunction = function() { menus[20].done = true; menus[19].done = false; menus[19].execute(); }

// RELIC ITEM MENU
menus[21] = new menu(40, 104, 240, 120, "equipItem");
menus[21].xOffset = 16;
menus[21].yOffset = 8;
menus[21].ySpacing = 12;
menus[21].cursorXOffset = 24;
menus[21].after = [20, 18];
menus[21].escapeFunction = function() { menus[21].done = true; menus[21].items = []; menus[21].selection = 0; menus[21].topSelection = 0; menus[20].done = false; menus[20].execute(); }

// STATUS MENU
menus[22] = new menu(40, 16, 240, 208, "status");
menus[22].after = [23];
menus[22].escapeFunction = function() { menus[22].done = true; menus[0].done = false; menus[0].execute(); }

// STATUS TOP LEFT WINDOW
menus[23] = new windowObject(40, 16, 64, 24, "Status", lightBlue, 8, 8);

// CONFIG MENU
menus[24] = new menu(40, 32, 240, 192);
menus[24].after = [25]
menus[24].escapeFunction = function() { menus[24].done = true; menus[0].done = false; menus[0].execute(); }

// CONFIG TOP LEFT WINDOW
menus[25] = new windowObject(216, 16, 64, 32, "Config", lightBlue, 8, 13);

menus[26] = new menu(40, 24, 240, 168, "save");
for (var i = 0; i < 3; i++)
{
  menus[26].addItem(undefined, function() { saveGame(); });
}
menus[26].escapeFunction = function() { menus[26].done = true; menus[0].done = false; menus[0].execute(); }

menus[27] = new menu(40, 96, 240, 64, "partyChanger");
for (var i = 0; i < 16; i++)
{
  menus[27].addItem("", undefined);
}
menus[27].party = partyReserve;
menus[27].numColumns = 7;
menus[27].xOffset = 16;
menus[27].yOffset = 6;
menus[27].xSpacing = 28;
menus[27].ySpacing = 28;
menus[27].before = [28, 29, 30];
menus[27].downFunction = function() { menus[27].done = true; menus[31].done = false; menus[31].execute(); }

menus[28] = new windowObject(40, 48, 240, 176);

menus[29] = new windowObject(40, 16, 64, 32, "Lineup", lightBlue, 8, 14);

menus[30] = new windowObject(104, 16, 176, 32, "Form 1 group(s)", white, 8, 14);

menus[31] = new menu(40, 160, 80, 64, "partyChanger");
for (var i = 0; i < 4; i++)
{
  menus[31].addItem("", undefined);
} 
menus[31].party = partyA;
menus[31].xOffset = 16;
menus[31].yOffset = 6;
menus[31].xSpacing = 28;
menus[31].ySpacing = 28;
menus[31].numColumns = 1;
menus[31].before = [28, 29, 30, 27];
menus[31].upFunction = function() { menus[31].done = true; menus[27].done = false; menus[27].execute(); }

menus[32] = new menu(120, 160, 80, 64, "partyChanger");
for (var i = 0; i < 4; i++)
{
  menus[32].addItem("", undefined);
} 
menus[32].party = partyB;
menus[32].xOffset = 16;
menus[32].yOffset = 6;
menus[32].xSpacing = 28;
menus[32].ySpacing = 28;
menus[32].numColumns = 1;
menus[32].before = [28, 29, 30, 27];
menus[32].upFunction = function() { menus[32].done = true; menus[27].done = false; menus[27].execute(); }

menus[33] = new menu(200, 160, 80, 64, "partyChanger");
for (var i = 0; i < 4; i++)
{
  menus[33].addItem("", undefined);
} 
menus[33].party = partyC;
menus[33].xOffset = 16;
menus[33].yOffset = 6;
menus[33].xSpacing = 28;
menus[33].ySpacing = 28;
menus[33].numColumns = 1;
menus[33].before = [28, 29, 30, 27];
menus[33].upFunction = function() { menus[33].done = true; menus[27].done = false; menus[27].execute(); }

function partyChanger()
{
  var num = 3;
  menus[30].text = "Form " + num + " group(s)";
  switch (num)
  {
    case 1:
    {
      menus[31].before = [28, 29, 30, 27];
    }
    case 2:
    {
      menus[31].before = [28, 29, 30, 27, 32];
      menus[32].before = [28, 29, 30, 27, 31];
      menus[31].rightFunction = function() { menus[31].done = true; menus[32].done = false; menus[32].execute(); }
    }
    case 3:
    {
      menus[31].before = [28, 29, 30, 27, 32, 33];
      menus[32].before = [28, 29, 30, 27, 31, 33];
      menus[33].before = [28, 29, 30, 27, 31, 32];
      menus[31].rightFunction = function() { menus[31].done = true; menus[32].done = false; menus[32].execute(); }
      menus[32].rightFunction = function() { menus[31].done = true; menus[32].done = false; menus[32].execute(); }
    }
  }
  menus[27].before = [28, 29, 30];
  for (var i = 0; i < num; i++)
  {
    menus[27].before[menus[27].before.length] = 31 + i;
  }
  menus[27].done = false;
  menus[27].execute();
}

function useItem()
{
  if (pick1 == undefined)
  {
    pick1 = menus[4].selection;
    menus[4].cursorClone = menus[4].selection;
    menus[4].escapeFunction = function() { pick1 = undefined; menus[4].cursorClone = undefined; menus[4].escapeFunction = function() { menus[4].done = true; menus[5].done = false; menus[5].before = [4, 6]; menus[5].execute(); } }    
  }
  else
  {
    menus[4].escapeFunction = function() { menus[4].done = true; menus[5].done = false; menus[5].before = [4, 6]; menus[5].execute(); }
    var pick2 = menus[4].selection;
    if (partyItems[pick1] != partyItems[pick2])
    {
      var item1 = partyItems[pick1];
      var item2 = partyItems[pick2];
      partyItems[pick1] = item2;
      partyItems[pick2] = item1;
    }
    else
    {
      if (partyItems[pick1] instanceof itemObject)
      {
        Abort("You will be using " + partyItems[pick1].name);
      }
      if (partyItems[pick1] instanceof handItemObject || partyItems[pick1] instanceof headItemObject || partyItems[pick1] instanceof bodyItemObject)
      {
        menus[7].done = false;
        menus[7].execute();
      }
    }
    pick1 = undefined;
    menus[4].cursorClone = undefined;
  }
}

function arrange()
{
  var array = [];
  for (var i = 0; i < gameItems.length; i++)
  {
    for (var p = 0; p < partyItems.length; p++)
    {
      if (gameItems[i] == partyItems[p])
      {
        array.push(partyItems[p]);
        break;
      }
    }
  }
  menus[5].before = [4, 6];
  menus[4].topSelection = 0;
  menus[4].selection = 0;
  return partyItems = array;
}

function partyPick()
{
  if (partyA[menus[1].selection])
  {
    switch(menus[0].selection)
    {
      case 1:
      {
        menus[1].done = true;
        menus[13].done = false;
        return menus[13].execute();
      }
      case 2:
      {
        menus[1].done = true;
        menus[15].done = false;
        return menus[15].execute();
      }
      case 3:
      {
        menus[1].done = true;
        menus[19].done = false;
        return menus[19].execute();
      }
      case 4:
      {
        menus[1].done = true;
        menus[22].done = false;
        return menus[22].execute();
      }
    }
  }
}

function equipItems(i)
{
  switch (i)
  {
    case 0:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof handItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[17].addItem(i, function() {});
            }
          }
        }
      }
      menus[16].done = true;
      menus[17].done = false;
      menus[17].execute();
    }
    case 1:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof handItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[17].addItem(i, function() {});
            }
          }
        }
      }
      menus[16].done = true;
      menus[17].done = false;
      menus[17].execute();
    }
    case 2:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof headItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[17].addItem(i, function() {});
            }
          }
        }
      }
      menus[16].done = true;
      menus[17].done = false;
      menus[17].execute();
    }
    case 3:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof bodyItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[17].addItem(i, function() {});
            }
          }
        }
      }
      menus[16].done = true;
      menus[17].done = false;
      menus[17].execute();
    }
    case 4:
    {
      var actorId = partyA[menus[1].selection].id;
      for (var i = 0; i < partyItems.length; i++)
      {
        if (partyItems[i] instanceof relicItemObject)
        {
          for (var p = 0; p < partyItems[i].equip.length; p++)
          {
            if (partyItems[i].equip[p] == actorId)
            {
              menus[21].addItem(i, function() {});
            }
          }
        }
      }
      menus[20].done = true;
      menus[21].done = false;
      menus[21].execute();
    }
  }
}

function actorCanUseSkill(type, actor)
{
  switch(type)
  {
    case "Espers":
    {
      if (actor.useEspers == true)
      {
        return true;
      }
    }
    case "Magic":
    {
      if (actor.useMagic == true)
      {
        return true;
      }
    }
    case "SwdTech":
    {
      if (actor.useSwdTech == true)
      {
        return true;
      }
    }
    case "Blitz":
    {
      if (actor.useBlitz == true)
      {
        return true;
      }
    }
    case "Lore":
    {
      if (actor.useLore == true)
      {
        return true;
      }
    }
    case "Rage":
    {
      if (actor.useRage == true)
      {
        return true;
      }
    }
    case "Dance":
    {
      if (actor.useDance == true)
      {
        return true;
      }
    }
  }
  return false;
}

function skillsMagic(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillMagic.length; i++)
    {
      menus[10].type = "magic";
      menus[10].addItem("", function() {})
    }
    menus[10].cursorXOffset = 24;
    menus[10].xOffset = 24;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 104;
    menus[10].ySpacing = 12;
    menus[10].numColumns = 1;
    menus[10].escapeFunction = function() { menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[13].done = false; menus[13].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].execute();
  }
}

function skillsEspers(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillMagic.length; i++)
    {
      menus[10].type = "espers";
      menus[10].addItem("", function() {})
    }
    menus[10].xOffset = 24;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 104;
    menus[10].ySpacing = 12;
    menus[10].numColumns = 1;
    menus[10].escapeFunction = function() { menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[13].done = false; menus[13].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].execute();
  }
}

function skillsSwordTech(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillSwordTech.length; i++)
    {
      menus[10].type = "swordTech";
      menus[10].addItem("", function() {})
    }
    menus[10].xOffset = 24;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 112;
    menus[10].ySpacing = 24;
    menus[10].numColumns = 1;
    menus[10].escapeFunction = function() { menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].execute();
  }
}

function skillsBlitz(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillBlitz.length; i++)
    {
      menus[10].type = "blitz";
      menus[10].addItem("", function() {})
    }
    menus[10].xOffset = 24;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 112;
    menus[10].ySpacing = 24;
    menus[10].numColumns = 1;
    menus[10].escapeFunction = function() { menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].execute();
  }
}

function skillsLore(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillLore.length; i++)
    {
      menus[10].type = "lore";
      menus[10].addItem("", function() {})
    }
    menus[10].xOffset = 16;
    menus[10].yOffset = 12;
    menus[10].ySpacing = 12;
    menus[10].numColumns = 0;
    menus[10].escapeFunction = function() { menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].execute();
  }
}

function skillsRage(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillLore.length; i++)
    {
      menus[10].type = "rage";
      menus[10].addItem("", function() {})
    }
    menus[10].xOffset = 32;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 112;
    menus[10].ySpacing = 12;
    menus[10].numColumns = 0;
    menus[10].escapeFunction = function() { menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].execute();
  }
}

function skillsDance(menu)
{
  if (actorCanUseSkill(menus[menu].items[menus[menu].selection].name, partyA[menus[1].selection]))
  {
    for (var i = 0; i < skillDance.length; i++)
    {
      menus[10].type = "dance";
      menus[10].addItem("", function() {})
    }
    menus[10].xOffset = 16;
    menus[10].yOffset = 12;
    menus[10].xSpacing = 112;
    menus[10].ySpacing = 24;
    menus[10].numColumns = 1;
    menus[10].escapeFunction = function() { menus[10].done = true; menus[10].selection = 0; menus[10].items = []; menus[14].done = false; menus[14].execute(); }
    menus[13].done = true;
    menus[10].done = false;
    menus[10].execute();
  }
}

function saveGame()
{
  var file = OpenFile("File " + menus[26].selection);
  file.write("Empty", false);
  
  for (var i = 0; i < partyA.length; i++)
  {
    if (partyA[i])
    {
      file.write("name", partyA[i].name);
      file.write("hp", partyA[i].hp);
      file.write("maxHp", partyA[i].maxHp);
      file.write("lv", partyA[i].level);
      file.write("id", partyA[i].id);
      break;
    }
  }
  for (var i = 0; i < partyA.length; i++)
  {
    if (partyA[i]) { file.write("pos" + i, partyA[i].id); }
    else { file.write("pos" + i, undefined); }
  }
  
  file.write("time", gameClock.getTime());
  file.write("gp", gp);
  file.write("steps", steps);
  file.write("map", GetCurrentMap());
  file.write("x", GetPersonX("Player"));
  file.write("y", GetPersonY("Player"));
  file.write("dir", GetPersonDirection("Player"));
  
  // Need to make seperate parties for multi party selection parts of the game - ie the party changer so that we dont lose those actors
  // Also need to make a seperate arrat for reserve members who are not in use so that we do not lose them either
  // Finally a back up array for actors that are unused, for temporary characters and whatknot
  
  // Then we need to save all of they're statistics, equipment, magic etc
  
  // Save all of the party Skills, keeping in mind the terms of gogo being able to use these skills
  
  // Save all of the items the party has
  
  // Recode the game function to handle the load menu
  
  // Then make a rework to save switches to handle events etc.
  
  // Then that should be it
}